<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package understrap
 */

get_header();

$container   = get_theme_mod( 'understrap_container_type' );
$sidebar_pos = get_theme_mod( 'understrap_sidebar_position' );

?>

<div class="wrapper" id="page-wrapper">

	<div class="<?php echo esc_html( $container ); ?>" id="content" tabindex="-1">

		<div class="row">

			<!-- Do the left sidebar check -->
			<?php get_template_part( 'global-templates/left-sidebar-check', 'none' ); ?>

			<main class="site-main" id="main">

				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'loop-templates/content', 'page' ); ?>
					<?php 
					
					if(get_field('uberschrift_aufbereitung')): 
						get_template_part('content', 'aufbereitung');
					endif;

					$ankaufsformular_anzeigen = get_field('ankaufsformular_anzeigen');
					if($ankaufsformular_anzeigen == true):
					get_template_part('formular', 'ankauf');
					endif;

					$fahrzeuge_anzeigen = get_field('fahrzeugliste_anzeigen');
					if($fahrzeuge_anzeigen == true):
					get_template_part('fahrzeuge', 'liste');
					endif;
					?>

					<?php get_template_part( 'loop-templates/content', 'services' ); ?>

				<?php endwhile; // end of the loop. ?>

			</main><!-- #main -->

		</div><!-- #primary -->

		<!-- Do the right sidebar check -->
		<?php if ( 'right' === $sidebar_pos || 'both' === $sidebar_pos ) : ?>

			<?php get_sidebar( 'right' ); ?>

		<?php endif; ?>

	</div><!-- .row -->

</div><!-- Container end -->

</div><!-- Wrapper end -->

<?php get_footer(); ?>
