Thanks for contributing to `_s` (Underscores) — you rock!

## Submitting issues
Before submitting your issue, make sure it has not been discussed earlier. You can search for existing tickets [here](https://github.com/Automattic/_s/search).

Here are some tips to consider and to help you write a great report:

* `_s` supports Microsoft Internet Explorer 11 and Edge, as well as the latest two versions of all other major browsers.
* `_s` is backwards compatible with the two versions prior to the current stable version of WordPress.
* `_s` uses HTML5 markup.
* We decided not to include translations [[#50](https://github.com/Automattic/_s/pull/50)] beyond the existing `_s.pot` file, a RTL stylesheet [[#263](https://github.com/Automattic/_s/pull/263)], or editor styles [[#225](https://github.com/Automattic/_s/pull/225)], as they are likely to change during development of an `_s`-based theme.

## Contributing code

Found a bug you can fix? Fantastic! Patches are always welcome. Here's a few tips for crafting a great pull request:

* Include the purpose of your PR. Be explicit about the issue your PR solves.
* Reference any existing issues that relate to your PR. This allows everyone to easily see all related discussions.
* When submitting a change that affects CSS, please make sure that both SCSS sources and output CSS have been updated equally.

By contributing code to `_s`, you grant its use under the [GNU General Public License v2 (or later)](http://www.gnu.org/licenses/gpl-2.0.html).

## Underscores.me
If your issue is specific to the [Underscores.me](http://underscores.me) website, the [Underscores.me GitHub repo](https://github.com/Automattic/underscores.me) is the right place for you.

The preferred method of generating a new theme based on `_s` is the [Underscores.me](http://underscores.me) website. If you have an alternative method, such as a shell script, write a blog post about it or host it in a separate repo -- and make sure to mention [@underscoresme](https://twitter.com/underscoresme) in your tweets!

Want to have your avatar listed as one of the `_s` contributors [here](http://underscores.me/#contribute)? Just make sure you have an email address added to both GitHub and your local Git installation.
