<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package understrap
 */

$container = get_theme_mod( 'understrap_container_type' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-title" content="<?php bloginfo( 'name' ); ?> - <?php bloginfo( 'description' ); ?>">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div class="hfeed site" id="page">

	<!-- ******************* The Navbar Area ******************* -->
	<div class="wrapper-fluid wrapper-navbar" id="wrapper-navbar">

		<a class="skip-link screen-reader-text sr-only" href="#content"><?php esc_html_e( 'Skip to content',
		'understrap' ); ?></a>

		<div id="hero"
		<?php 
		$hero = get_field('hero_bild');
		if(!empty($hero)) {?>
		style="background: url('<?php echo $hero['url']; ?>') no-repeat; 
		background-size: cover;
		background-position: 50% 50%;
		-webkit-clip-path: polygon(0% 0%, 100% 0%, 100% 97%, 82% 97%, 83% 100%, 84% 97%, 0% 97%);
		<?php $hero_hohe = get_field('hero_hohe');
		if($hero_hohe == true):
		echo 'height: 100vh;';
		else:
			echo 'height: 65vh;';
		endif;
		?>
		"
		<?php } else { ?>
		style="background: url('<?php echo get_the_post_thumbnail_url(); ?>') no-repeat;
		background-size: cover;
		background-position: 50% 50%;
		-webkit-clip-path: polygon(0% 0%, 100% 0%, 100% 97%, 82% 97%, 83% 100%, 84% 97%, 0% 97%);
		height: 100vh;
		"
		<?php } ?>
		>

		<?php if ( 'container' == $container ) : ?>
			<div class="container">
		<?php endif; ?>

			<!-- 	<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button> -->

				<a href="/" id="logo" class="hidden-sm-down"><img src="/wp-content/themes/sauer/img/aps_logo_wide.svg" width="600" height="200" /></a>
				<a href="#start" class="startlink" class="col-12""><span class="gotonav"><span></span><span></span><span></span></span></a>
				<br>
				<br>
				<br>
				<br>
				<br>
				<br>
				<br>
				<a href="/" id="logo-mobile" class="hidden-md-up col-12 text-center"><img src="/wp-content/themes/sauer/img/aps_logo.svg" class="img-fluid" width="300" /></a>
			
			<?php if ( 'container' == $container ) : ?>
			</div><!-- .container -->
			<?php endif; ?>
			<div class="container hidden-sm-down" id="hero-content">
			<?php if(get_field('hero_text')) { ?>
			<div class="content col-12 col-lg-6">
			<h3><?php the_field('hero_text'); ?></h3>
			</div>
		<?php } else { ?>
			<div class="content col-12 col-lg-6">
			<h3><?php the_title(); ?></h3>
			</div>
		<?php } ?>
			<div class="search col-12">
				<div class="row">
				<div class="col-lg-2"><i class="fa fa-search"></i> <strong>Schnellsuche</strong></div>
				<div class="col-lg-3"><?php echo do_shortcode('[facetwp facet="marke"]'); ?></div>
				<div class="col-lg-3"><?php echo do_shortcode('[facetwp facet="modell"]'); ?></div>
				<div class="col-lg-4"><button class="btn btn-primary btn-block" type="button" onclick="fwp_redirect()"><span style="display: inline;"><?php echo do_shortcode('[facetwp counts="true"]'); ?></span></button></div>
				</div>
				<div style="display: none;">
				<?php
				$fahrzeuge_anzeigen = get_field('fahrzeugliste_anzeigen');
				// var_dump($fahrzeuge_anzeigen);
				if($fahrzeuge_anzeigen == false):
				echo do_shortcode('[facetwp template="hidden_search"]');
				endif;
				 ?>
				 </div>
				<script type="text/javascript">			
				function fwp_redirect() {
				    FWP.parse_facets();
				    FWP.set_hash();
				    var query = FWP.build_query_string();
				    window.location.href = '/verkauf/?' + query;
				}
				</script>
			</div>

			</div>
		</div><!-- .site-navigation -->

		<div class="container" id="start">
	
		<div id="navtrigger" class="text-center"><span class="gotonav text-center"><span></span><span></span><span></span></span></div>

		<div class="nav-toggler row hidden-md-down">
		<div class="col-md-4 col-xs-12">
		<a class="logo-nav" href="/"><img src="/wp-content/themes/sauer/img/aps_logo_wide.svg" width="550" height="150" /></a>
		</div>
		<div class="col-md-3 col-xs-12">
		<?php if(get_field('telefonnummer_gebrauchtwagenhandel', 'option')): ?>
		<span style="display: block;" class="red"><i class="fa fa-phone"></i> <strong><?php the_field('telefonnummer_gebrauchtwagenhandel', 'option'); ?></strong></span>
		<?php endif; ?>
		<?php if(get_field('telefonnummer_autopflegeservice', 'option')): ?>
		<span class="gray"><i class="fa fa-phone"></i> <strong><?php the_field('telefonnummer_autopflegeservice', 'option'); ?></strong></span>
		<?php endif; ?>
		</div>
		<div class="col-md-5 col-xs-12">
		<div class="row">
		<div class="col-md-12">
		<?php if(get_field('adresse_gebrauchtwagenhandel', 'option')): ?>
		<span style="display: block;" class="red"><?php the_field('adresse_gebrauchtwagenhandel', 'option'); ?></span>
		<?php endif; ?>
		<?php if(get_field('adresse_autopflegeservice', 'option')): ?>
		<span style="display: block;" class="gray"><?php the_field('adresse_autopflegeservice', 'option'); ?></span>
		<?php endif; ?>
		</div>
		
		
		</div>
		</div>



		</div>
		</div> <!-- //.container -->
		<div class="container-fluid"><hr></div>
		<div class="container">

		<div class=" <?php 
		$menu = get_field('menu_geoffnet');
		if($menu == true): echo 'showmenu'; endif; ?>
		" id="sauerNav"
		
		>
		<div class="close-btn hidden-lg-down" id="close-alternative"><span></span><span></span></div>
		
		<div class="row">

		<div class="menu-container col-12 col-lg-8">
	
		
		
			<!-- The WordPress Menu goes here -->
					<?php wp_nav_menu(
					array(
						'theme_location'  => 'primary',
						'container_class' => 'navbar-collapse',
						'container_id'    => '',
						'menu_class'      => 'navbar-nav row row',
						'fallback_cb'     => '',
						'items_wrap'	  => '<ul id="%1$s" class="%2$s col-sm-12">%3$s</ul>',
						'menu_id'         => 'main-menu',
						'walker'          => new WP_Bootstrap_Navwalker(),
					)
				); ?>
			
		
		</div><!-- .menu-container close -->
		<?php $top_angebote_bild = get_field('bild_unsere_angebote', 'option'); ?>
		<?php if(!empty($top_angebote_bild)): ?>
		<div class="top-angebote col-12 col-lg-4"><img src="<?php echo $top_angebote_bild['url']; ?>" /></div>
		<?php endif; ?>

		</div><!-- .row close -->

		<!-- <div class="menu-bottom"> -->
		<hr>

		<div class="row">
		<!-- <div class="col-12"> -->
			<div class="col-12 col-lg-3"><img src="/wp-content/themes/sauer/img/icon1.svg" width="50" height="50" /> Fahrzeug Probefahren/-kaufen</div>
			<div class="col-12 col-lg-2"><img src="/wp-content/themes/sauer/img/icon2.svg" width="50" height="50" /> Fahrzeug Reparatur</div>
			<div class="col-12 col-lg-2"><img src="/wp-content/themes/sauer/img/icon3.svg" width="50" height="50" /> Termin Vereinbaren</div>
			<?php if(get_field('button_text_unsere_angebote', 'option')): ?>
			<div class="col-12 col-lg-4 push-lg-1">
			<a href="<?php if(get_field('button_link_unsere_angebote', 'option')):  the_field('button_link_unsere_angebote', 'option'); endif; ?>" class="btn btn-block btn-primary"><?php the_field('button_text_unsere_angebote', 'option'); ?></a></div>
		<?php endif; ?>
			<!-- <div class="col-2"></div> -->
		<!-- </div> -->

		<!-- </div> -->
		</div>

		<hr>
		</div>
		<!-- Menu End -->
		</div>
	</div><!-- .wrapper-navbar end -->
