<?php
function understrap_remove_scripts() {
    wp_dequeue_style( 'understrap-styles' );
    wp_deregister_style( 'understrap-styles' );

    wp_dequeue_script( 'understrap-scripts' );
    wp_deregister_script( 'understrap-scripts' );

    // Removes the parent themes stylesheet and scripts from inc/enqueue.php
}
add_action( 'wp_enqueue_scripts', 'understrap_remove_scripts', 20 );

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {

	// Get the theme data
	$the_theme = wp_get_theme();

    wp_enqueue_style( 'child-understrap-styles', get_stylesheet_directory_uri() . '/css/child-theme.min.css', array(), $the_theme->get( 'Version' ) );
    wp_enqueue_style( 'fancybox-styles', get_stylesheet_directory_uri() . '/css/jquery.fancybox.min.css', array(), $the_theme->get( 'Version' ) );
    wp_enqueue_script( 'child-understrap-scripts', get_stylesheet_directory_uri() . '/js/child-theme.min.js', array(), $the_theme->get( 'Version' ), true );
    wp_enqueue_script( 'fancybox-scripts', get_stylesheet_directory_uri() . '/js/jquery.fancybox.min.js', array(), $the_theme->get( 'Version' ), true );
}


function aps_custom_scripts() {
    $the_theme = wp_get_theme();
    // wp_enqueue_script( 'scrollreveal', get_stylesheet_directory_uri() . '/js/scrollreveal.js', array(), $the_theme->get( 'Version' ), true);
    wp_enqueue_script( 'zaz-scripts', get_stylesheet_directory_uri() . '/js/aps.js', array(), $the_theme->get( 'Version' ), true);

}

add_action( 'init', 'aps_custom_scripts');

// add options page

// add options page for general theme settings
$args = array(
    
    /* (string) The title displayed on the options page. Required. */
    'page_title' => 'Globale Einstellungen',
    
    /* (string) The title displayed in the wp-admin sidebar. Defaults to page_title */
    'menu_title' => 'Globale Einst.',
    
    /* (string) The slug name to refer to this menu by (should be unique for this menu). 
    Defaults to a url friendly version of menu_slug */
    'menu_slug' => 'sauer-setttings',
    
    /* (string) The capability required for this menu to be displayed to the user. Defaults to edit_posts.
    Read more about capability here: http://codex.wordpress.org/Roles_and_Capabilities */
    'capability' => 'edit_posts',
    
    /* (int|string) The position in the menu order this menu should appear. 
    WARNING: if two menu items use the same position attribute, one of the items may be overwritten so that only one item displays!
    Risk of conflict can be reduced by using decimal instead of integer values, e.g. '63.3' instead of 63 (must use quotes).
    Defaults to bottom of utility menu items */
    'position' => false,
    
    /* (string) The slug of another WP admin page. if set, this will become a child page. */
    'parent_slug' => '',
    
    /* (string) The icon class for this menu. Defaults to default WordPress gear.
    Read more about dashicons here: https://developer.wordpress.org/resource/dashicons/ */
    'icon_url' => false,
    
    /* (boolean) If set to true, this options page will redirect to the first child page (if a child page exists). 
    If set to false, this parent page will appear alongside any child pages. Defaults to true */
    'redirect' => true,
    
    /* (int|string) The '$post_id' to save/load data to/from. Can be set to a numeric post ID (123), or a string ('user_2'). 
    Defaults to 'options'. Added in v5.2.7 */
    'post_id' => 'options',
    
    /* (boolean)  Whether to load the option (values saved from this options page) when WordPress starts up. 
    Defaults to false. Added in v5.2.8. */
    'autoload' => false,
    
);

acf_add_options_page( $args );

// Register Custom Post Type
function service_cpt() {

    $labels = array(
        'name'                  => _x( 'Service', 'Post Type General Name', 'leistung_cpt' ),
        'singular_name'         => _x( 'Service', 'Post Type Singular Name', 'service_cpt' ),
        'menu_name'             => __( 'Service', 'service_cpt' ),
        'name_admin_bar'        => __( 'Service', 'service_cpt' ),
        'archives'              => __( 'Service Archive', 'service_cpt' ),
        'attributes'            => __( 'Service Eigenschaften', 'service_cpt' ),
        'parent_item_colon'     => __( 'Elternelement:', 'service_cpt' ),
        'all_items'             => __( 'Alle Services', 'service_cpt' ),
        'add_new_item'          => __( 'Neuen Service hinzufügen', 'service_cpt' ),
        'add_new'               => __( 'Neuer Service', 'service_cpt' ),
        'new_item'              => __( 'Neu', 'service_cpt' ),
        'edit_item'             => __( 'Service bearbeiten', 'service_cpt' ),
        'update_item'           => __( 'Service aktualisieren', 'service_cpt' ),
        'view_item'             => __( 'Service ansehen', 'service_cpt' ),
        'view_items'            => __( 'Service ansehen', 'service_cpt' ),
        'search_items'          => __( 'Service durchsuchen', 'service_cpt' ),
        'not_found'             => __( 'Nichts gefunden', 'service_cpt' ),
        'not_found_in_trash'    => __( 'im Papierkorb nichts gefunden', 'service_cpt' ),
        'featured_image'        => __( 'Hauptbild', 'service_cpt' ),
        'set_featured_image'    => __( 'Als Hauptbild setzen', 'service_cpt' ),
        'remove_featured_image' => __( 'Hauptbild entfernen', 'service_cpt' ),
        'use_featured_image'    => __( 'Als Hauptbild benutzen', 'service_cpt' ),
        'insert_into_item'      => __( 'Zu Service hinzufügen', 'service_cpt' ),
        'uploaded_to_this_item' => __( 'Zu Service hochladen', 'service_cpt' ),
        'items_list'            => __( 'Service Liste', 'service_cpt' ),
        'items_list_navigation' => __( 'Service Listen Navigation', 'service_cpt' ),
        'filter_items_list'     => __( 'Service Listen Filter', 'service_cpt' ),
    );
    $args = array(
        'label'                 => __( 'Service', 'service_cpt' ),
        'description'           => __( 'Services als Boxen auf der Seite', 'service_cpt' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'thumbnail', ),
        'taxonomies'            => array( ),
        'hierarchical'          => false,
        'public'                => false,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-yes',
        'show_in_admin_bar'     => false,
        'show_in_nav_menus'     => false,
        'can_export'            => true,
        'has_archive'           => false,        
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type( 'Service', $args );

}
add_action( 'init', 'service_cpt', 0 );

// Register Custom Post Type
function aufbereitung_cpt() {

    $labels = array(
        'name'                  => _x( 'Aufbereitungen', 'Post Type General Name', 'aufbereitung_cpt' ),
        'singular_name'         => _x( 'Aufbereitung', 'Post Type Singular Name', 'aufbereitung_cpt' ),
        'menu_name'             => __( 'Aufbereitungen', 'aufbereitung_cpt' ),
        'name_admin_bar'        => __( 'Aufbereitungen', 'aufbereitung_cpt' ),
        'archives'              => __( 'Aufbereitungs Archive', 'aufbereitung_cpt' ),
        'attributes'            => __( 'Aufbereitungs Eigenschaften', 'aufbereitung_cpt' ),
        'parent_item_colon'     => __( 'Eltern element:', 'aufbereitung_cpt' ),
        'all_items'             => __( 'Alle Aufbereitungen', 'aufbereitung_cpt' ),
        'add_new_item'          => __( 'Neue Aufbereitung hinzufügen', 'aufbereitung_cpt' ),
        'add_new'               => __( 'Neue Aufbereitung', 'aufbereitung_cpt' ),
        'new_item'              => __( 'Neu', 'aufbereitung_cpt' ),
        'edit_item'             => __( 'Aufbereitung bearbeiten', 'aufbereitung_cpt' ),
        'update_item'           => __( 'Aufbereitung aktualisieren', 'aufbereitung_cpt' ),
        'view_item'             => __( 'Aufbereitung ansehen', 'aufbereitung_cpt' ),
        'view_items'            => __( 'Aufbereitung ansehen', 'aufbereitung_cpt' ),
        'search_items'          => __( 'Aufbereitung durchsuchen', 'aufbereitung_cpt' ),
        'not_found'             => __( 'Nichts gefunden', 'aufbereitung_cpt' ),
        'not_found_in_trash'    => __( 'im Papierkorb nichts gefunden', 'aufbereitung_cpt' ),
        'featured_image'        => __( 'Hauptbild', 'aufbereitung_cpt' ),
        'set_featured_image'    => __( 'Als Hauptbild setzen', 'aufbereitung_cpt' ),
        'remove_featured_image' => __( 'Hauptbild entfernen', 'aufbereitung_cpt' ),
        'use_featured_image'    => __( 'Als Hauptbild benutzen', 'aufbereitung_cpt' ),
        'insert_into_item'      => __( 'Zu Aufbereitung hinzufügen', 'aufbereitung_cpt' ),
        'uploaded_to_this_item' => __( 'Zu Aufbereitung hochladen', 'aufbereitung_cpt' ),
        'items_list'            => __( 'Aufbereitungs Liste', 'aufbereitung_cpt' ),
        'items_list_navigation' => __( 'Aufbereitungs Listen Navigation', 'aufbereitung_cpt' ),
        'filter_items_list'     => __( 'Aufbereitungs Listen Filter', 'aufbereitung_cpt' ),
    );
    $args = array(
        'label'                 => __( 'Aufbereitung', 'aufbereitung_cpt' ),
        'description'           => __( 'Aufbereitungs Pakete', 'aufbereitung_cpt' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'thumbnail', ),
        'taxonomies'            => array( ),
        'hierarchical'          => false,
        'public'                => false,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-yes',
        'show_in_admin_bar'     => false,
        'show_in_nav_menus'     => false,
        'can_export'            => true,
        'has_archive'           => false,        
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type( 'Aufbereitungen', $args );

}
add_action( 'init', 'aufbereitung_cpt', 0 );


add_filter( 'facetwp_result_count', function( $output, $params ) {
    $output = $params['total'] . ' ERGEBSISSE ANZEIGEN';
    return $output;
}, 10, 2 );