<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package understrap
 */

$the_theme = wp_get_theme();
$container = get_theme_mod( 'understrap_container_type' );
?>

<?php get_sidebar( 'footerfull' ); ?>

<div class="wrapper" id="wrapper-footer">

	<div class="container-fluid">

		<div class="row">

			<div class="col-md-12">
			<div class="parallax">
				<div class="container">
	<div class="row">
	<div class="col-12"><h2 class="entry-title text-center">KONTAKT</h2><hr></div>
	<?php if(get_field('box_links', option)): ?>
	<div class="col-md-4 footer-box">
	<?php the_field('box_links', option); ?>
	</div>
	<div class="col-md-4 push-md-4  footer-box">
	<h3 class="">Ihre Anfrage:<br><br></h3>
	<?php echo do_shortcode('[contact-form-7 id="92" title="Kontakt Footer"]'); ?>
	</div>
	<?php endif; ?>
	</div>
	</div>
			</div>

	<?php
	// WP_Query arguments
	$args = array(
		'post_type'              => array( 'fahrzeuge' ),
		'posts_per_page'         => '8',
		'order'                  => 'DESC',
		'orderby'                => 'date',
	);

	// The Query
	$query = new WP_Query( $args );

	// The Loop
	if ( $query->have_posts() ) {
		?>
		<br>
		<br>
		<div class="container">
		<div class="fahrzeug-karusell">
		<?php
		while ( $query->have_posts() ) {
			$query->the_post(); $meta_values = get_post_meta(get_the_ID()); 
			// do something
			?>
			<div class="fahrzeug-item text-center">
			<strong class="fahrzeug-title"><a style="color: black;" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></strong><br><br>
			<?php the_post_thumbnail('large'); ?>
			<?php if(!empty($meta_values['price'][0])) {
				echo '<br><div class="text-center fahrzeug-preis"><strong>' . $meta_values['price'][0] . ' EUR</strong></div>';
				if ($meta_values['vatable'][0] == 'false') {
                echo '<small>MwSt. nicht ausweisbar</small>';
           		 } else {
                echo '<small>Inkl. 19% MwSt.</small>';
            	}
			}
			?>
			<hr>
			<?php
			if (!empty($meta_values['emissionFuelConsumption_Combined'][0])) {
            echo '<span>Verbrauch komb.*:</span> <strong> ≈' . $meta_values['emissionFuelConsumption_Combined'][0] . ' l/100km</strong><br>';
	        }
	        if (!empty($meta_values['emissionFuelConsumption_CO2'][0])) {
	           echo '<span>CO2-Emissionen komb.*:</span> <strong> ≈' . $meta_values['emissionFuelConsumption_CO2'][0] . ' g/km</strong><br>';
	        }
			?>
			</div>
			<?php
		}
		?>
		</div>
		</div>
		<?php
	} 

	// Restore original Post Data
	wp_reset_postdata();
	?>

				<footer class="site-footer" id="colophon">
				<br>
				<div class="foooter-menu text-center">
				<a href="/impressum" style="color: black;">IMPRESSUM</a> | <a href="/datenschutz" style="color: black;">DATENSCHUTZ</a>
				</div>

				</footer><!-- #colophon -->

			</div><!--col end -->

		</div><!-- row end -->

	</div><!-- container end -->

	

</div><!-- wrapper end -->

</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>

