<?php



// function add_admin_jquery() {

// 	wp_register_script(

// 	'admin_settings',

// 	plugin_dir_url(__FILE__) . 'js/admin_settings.js',

// 	array('jquery')

// 	);

// 	wp_enqueue_script('admin_settings');

// }







/*Settings class */





class mob_Setting{

    /**

     * Holds the values to be used in the fields callbacks

     */

    private $options;



    public function __construct($mob_data)

    {

		$this->mob_data=$mob_data;



        add_action( 'admin_menu', array( $this, 'add_options_page' ) );

        add_action( 'admin_init', array( $this, 'register_options' ) );

        

    }

    

   

    

    /**

     * Add a new item in options menu to access the options page

     */

    public function add_options_page()

    {

        // This page will be under "Settings"

        add_menu_page(

            'Settings Admin', 

            'kfz-web Import', 

            'manage_options', 

            'searchde-setting-admin', /* Page ID */

            array( $this, 'create_options_page' ),

            'dashicons-admin-generic'

        );

    }

   /**

     * Options page callback that create all the fields used in settings

     */

    public function create_options_page()

    {

        // Set class property

        $this->options = get_option( 'MobileDE_option' );//option name

		if(empty( $this->options['mob_download_interval'])){

			 $this->options['mob_download_interval']='daily';

		}

// function getVehiclesFromApiAdmin()

// {

// 	$options = get_option('MobileDE_option');

// 	$vehicles = array();



// 	// Maybe a if (is_array(mob_username)) is needed here to serve single-account users. --bth 2014-10-31 06:06:34



// 	for ($i = 0; $i < count(isset($options['mob_username'])); $i++) {

// 		$mob_api = new mob_searchAPI("mob_url", isset($options['mob_username'][$i]), isset($options['mob_password'][$i]), isset($options['mob_language']));

// 		$temp = $mob_api->getAllAds();

// 		if (!empty($temp)) {



// 			// Merge data from different API accounts



// 			if (isset($temp['intern_adKeys'])) {

// 				if (isset($vehicles['intern_adKeys'])) {

// 					$tempInternAdKeys = array_merge($vehicles['intern_adKeys'], $temp['intern_adKeys']);

// 				}

// 				else {

// 					$tempInternAdKeys = $temp['intern_adKeys'];

// 				}

// 			}



// 			$vehicles = array_merge($vehicles, $temp);

// 			if (isset($tempInternAdKeys)) {



// 				// Write tempAdKeys back to array (overwrite).



// 				$vehicles['intern_adKeys'] = $tempInternAdKeys;

// 			}



// 			// ToDo:

// 			// Equeue Status Message for Backend: "Account .... has ... vehicles"

// 			// --bth 2014-11-11



// 		}

// 		else {



// 			// $temp was empty!

// 			// Add error handling.



// 		}

// 	}



// 	//    file_put_contents('testlog.txt', print_r($vehicles, true));



// 	return $vehicles;

// }

?>

<div class="wrap">

<img src="http://www.mobilede-fahrzeugintegration.de/wp-content/uploads/2016/10/kfz-web-logo.png"> </img>

            <?php screen_icon(); ?>

            <h2><?php __('MobileDE Settings'); ?></h2>



	<form class="inputForm" method="post" action="options.php">

            <?php

                // This prints out all hidden setting fields

                settings_fields( 'MobileDE_option' );   

                do_settings_sections( 'searchde-setting-admin' );

                submit_button(); 

				

				

            ?><input class="button-primary" type="button"

			id="importData" value="Fahrzeuge importieren" /> <input

			class="button-primary" type="button" id="deletePosts"

			value="Fahrzeuge löschen" />

			



			

	</form>



	<?php

		// $options = ini_get_all();

		// $memory_limit = str_replace('M', '', $options['memory_limit']['global_value']);

		



		// 	if($memory_limit <= '128') {

		// 		echo '<div class="notice notice-error">';

		// 	}

		// 	elseif ($memory_limit >= '256') {

		// 		echo '<div class="notice notice-warning">';



		// 	}

			

			

		?>

		<?php 

		// PHP Version check

		if (version_compare(PHP_VERSION, '5.4.0') <= 0) {

    		echo '

    		<div class="notice notice-error"><p>

    		Das Plugin benötigt min. PHP 5.4. Ihre PHP-Version: ' . PHP_VERSION . "\n" . '</p></div>';

		}

		else {

			echo '

			<div class="notice notice-success is-dismissible"><p>

			Ihre PHP-Version:<strong> ' . PHP_VERSION . "\n" . '</strong>

			<button type="button" class="notice-dismiss">

			<span class="screen-reader-text">Dismiss this notice.</span></p></div>

			</button>

			';

		}

		?>

		<?php

		$license 	= get_option( 'mob_license_key' );

		$status 	= get_option( 'mob_license_status' );

		if( $status == false && $status !== 'valid' ) { 

			echo'

			<div class="notice notice-error"><p>

			Das Plugin ist nicht aktiviert. Falls Sie Probleme mit der Aktivierung haben, Prüfen sie ob das Plugin schon auf einer anderen Seite aktiviert wurde. <b>Deaktivieren</b> sie das Plugin auf der vorherigen Domain und <b>aktivieren</b> es anschließend auf dieser Seite.</p><p>Wenn sie keinen Zugang zu Ihrer vorherigen Domain haben, schreiben sie uns ein <a target="_blank" href="http://support.neusued-media.de/">Ticket</a> unter http://support.neusued-media-de/

			</p></div>

			';

		}

		?>

		<?php

		// PHP Memory Limit Check

		$options = ini_get_all();

		$memory_limit = str_replace('M', '', $options['memory_limit']['global_value']);



			if($memory_limit < '128') {

				echo '

				<div class="notice notice-error"><p>

				Das Memory Limit liegt derzeit bei:<strong> '. $options['memory_limit']['global_value'] . '</strong> (memory_limit) | Wir empfehlen mind. <strong>128M</strong>.

				</p></div>

				';

			}

			elseif ($memory_limit >= '128' && $memory_limit < '256') {

				echo '<div class="notice notice-warning"><p>

				Das Memory Limit liegt derzeit bei:<strong> '. $options['memory_limit']['global_value'] . '</strong> (memory_limit).

				</p></div>';

			}

			elseif ($memory_limit >= '256') {

				echo '<div class="notice notice-success is-dismissible"><p>

				Das Memory Limit liegt derzeit bei:<strong> '. $options['memory_limit']['global_value'] . '</strong> (memory_limit).

				<button type="button" class="notice-dismiss">

				<span class="screen-reader-text">Dismiss this notice.</span>

				</button>

				</p></div>';

			}	

		?>



		<?php 

		// PHP Max Execution Time Check

		$max_execution_time = ini_get('max_execution_time');

			if($max_execution_time >= '60') {

				echo '<div class="notice notice-success is-dismissible"><p>

				Die Maximale Scriptausführungszeit liegt bei:<strong> '.$max_execution_time.'</strong> Sekunden.

				<button type="button" class="notice-dismiss">

				<span class="screen-reader-text">Dismiss this notice.</span>

				</button>

				</p></div>';

			}

			else {

				echo '<div class="notice notice-warning"><p>

				Die Maximale Scriptausführungszeit liegt bei:<strong> '.$max_execution_time.'</strong> Sekunden | Wir empfehlen mind. <strong>60</strong> Sekunden.<br>

				<small>Wenn kein höherer Wert möglich ist setzen sie die Option unterhalb bei "Bild-Speicherort" auf "Bilder bei mobile.de holen".</small>

				</p></div>';	

			}

		?>

		

		<?php 

		// PHP allow_url_fopen Check

		$allow_url_fopen = $options['allow_url_fopen']['global_value'];

			if ($allow_url_fopen == 0) {

				echo '<div class="notice notice-error"><p>

				allow_url_fopen muss auf <strong>"ON"</strong> gestellt sein.

				</p></div>';

			}

			else {

				echo '<div class="notice notice-success is-dismissible"><p>

				allow_url_fopen ist <strong>"ON"</strong>.

				<button type="button" class="notice-dismiss">

				<span class="screen-reader-text">Dismiss this notice.</span>

				</button>

				</p></div>';

			}



	}



   /**

     * Register all fields used in settings

     */

   

    public function register_options()

    { 

        register_setting(

            'MobileDE_option', // Option group

            'MobileDE_option', // Option name

            array( $this, 'sanitize' ) // Sanitize

        );

		add_settings_section(

            'connection_section_id', // Section ID

            'Verbindungseinstellungen', // Title

            array( $this, 'print_section_info' ), // Callback

            'searchde-setting-admin' // Page ID

        );

        // add_settings_field(

        //     'mob_url', // ID

        //     'Mobile.de API URL', // Title 

        //     array( $this, 'mob_url_callback' ), // Callback

        //     'searchde-setting-admin', // Page

        //     'connection_section_id' // Section           

        // );

		add_settings_field(

            'mob_username', 

            'Benutzername', 

            array( $this, 'mob_username_callback' ), 

            'searchde-setting-admin', 

            'connection_section_id'

        );



		add_settings_field(

            'mob_password', 

            'Passwort', 

            array( $this, 'mob_password_callback' ), 

            'searchde-setting-admin', 

            'connection_section_id'         



    	);

    	add_settings_field(

            'mob_download_interval', 

            'Import Intervall', 

            array( $this, 'mob_download_interval_callback' ), 

            'searchde-setting-admin', 

            'connection_section_id'

        );

            

        add_settings_field(

            'mob_language', 

            'Sprache', 

            array( $this, 'mob_language_callback' ), 

            'searchde-setting-admin', 

            'connection_section_id'

        );



        add_settings_field(

            'mob_image_option', 

            'Bild-Speicherort', 

            array( $this, 'mob_image_callback' ), 

            'searchde-setting-admin', 

            'connection_section_id'

        );



  		add_settings_field(

            'mob_bootstrap_option', 

            'Bootstrap CDN', 

            array( $this, 'mob_bootstrap_callback' ), 

            'searchde-setting-admin', 

            'connection_section_id'

        );



  		add_settings_field(

            'mob_slider_option', 

            'Slickslider', 

            array( $this, 'mob_slider_callback' ), 

            'searchde-setting-admin', 

            'connection_section_id'

        );

  			add_settings_field(

            'use_cat_tax', 

            'Standard Kategorien', 

            array( $this, 'mob_cat_tax_callback' ), 

            'searchde-setting-admin', 

            'connection_section_id'

        );

  		

		//register AJAX handlers

		// add_action( 'wp_ajax_ajaxGetBrand', 'mob_ajaxGetBrand' );

		// add_action( 'wp_ajax_ajaxGetCategory', 'mob_ajaxGetCategory' );

		// add_action( 'wp_ajax_ajaxGetModel', 'mob_ajaxGetModel' );

		// add_action( 'wp_ajax_ajaxGetFeatures', 'mob_ajaxGetFeatures' );

		add_action( 'wp_ajax_ajaxImportData', 'mob_ajaxImportData' );

		add_action( 'wp_ajax_ajaxDeletePosts', 'mob_ajaxDeletePosts' );



		function mob_ajaxImportData(){

			

			$error=mob_download_import_feed();



			if(empty($error)) {

				die('1');

			}else {

				die($error);

			}

		}

		function mob_ajaxDeletePosts(){

			mob_deleteAllPosts();

			die('1');

		}

	}

	

		public function sanitize( $data )

		{

			$new_data = array();



			if(!empty($data['mob_url'])){

				$new_data['mob_url']=sanitize_text_field($data['mob_url']);

			}



			if(!empty($data['mob_username'])){

				for($i=0;$i<count($data['mob_username']);$i++) {

					if(!empty($data['mob_username'][$i])){

						$new_data['mob_username'][$i]=sanitize_text_field(trim($data['mob_username'][$i]));

						$new_data['mob_password'][$i]=sanitize_text_field(trim($data['mob_password'][$i]));

					}

				}

			}



			if(!empty($data['mob_language'])){

				$new_data['mob_language']=sanitize_text_field($data['mob_language']);

			}

			if(!empty($data['mob_download_interval'])){

				$new_data['mob_download_interval']=sanitize_text_field($data['mob_download_interval']);

				

				$this->options = get_option( 'MobileDE_option' );



				//update the interval of scheduler

				if($new_data['mob_download_interval'] != $this->options['mob_download_interval']) {

					mob_update_schedule($new_data['mob_download_interval']);

				}

			}

		

			if(!empty($data['mob_image_option'])) {

				$new_data['mob_image_option']=sanitize_text_field($data['mob_image_option']);

			}



			if(!empty($data['mob_bootstrap_option'])) {

				$new_data['mob_bootstrap_option']=sanitize_text_field($data['mob_bootstrap_option']);

			}



			if(!empty($data['mob_slider_option'])) {

				$new_data['mob_slider_option']=sanitize_text_field($data['mob_slider_option']);

			}	

			if(!empty($data['mob_cat_tax_option'])) {

				$new_data['mob_cat_tax_option']=sanitize_text_field($data['mob_cat_tax_option']);

			}

			

			//add search per classes, brand, models, variant (model description)

			if(!empty($data['class'])){

				$new_data['class']=sanitize_text_field($data['class']);



				if(!empty($data['brand'])){

					$new_data['brand']=sanitize_text_field($data['brand']);



					if(!empty($data['model'])){

						$new_data['model']=sanitize_text_field($data['model']);

					}



					if(!empty($data['variant'])){

						$new_data['variant']=sanitize_text_field($data['variant']);

					}

				}

			}

				if(!empty($data['category'])){

				$new_data['category']=sanitize_text_field(trim($data['category']));

			}

			if(!empty($data['firstRegistrationDateMin'])){

				$new_data['firstRegistrationDateMin']=sanitize_text_field(trim($data['firstRegistrationDateMin']));

			}

			if(!empty($data['firstRegistrationDateMax'])){

				$new_data['firstRegistrationDateMax']=sanitize_text_field(trim($data['firstRegistrationDateMax']));

			}



			if(!empty($data['owners'])){

				$new_data['owners']=sanitize_text_field($data['owners']);

			}

			if(!empty($data['mileageFrom'])){

				$new_data['mileageFrom']=sanitize_text_field(trim($data['mileageFrom']));

			}

			if(!empty($data['mileageTo'])){

				$new_data['mileageTo']=sanitize_text_field(trim($data['mileageTo']));

			}

			if(!empty($data['monthsTillInspection'])){

				$new_data['monthsTillInspection']=sanitize_text_field($data['monthsTillInspection']);

			}

			if(!empty($data['powerMin'])){

				$new_data['powerMin']=sanitize_text_field(trim($data['powerMin']));

			}

			if(!empty($data['powerMax'])){

				$new_data['powerMax']=sanitize_text_field(trim($data['powerMax']));

			}

			if(!empty($data['cubicCapacityMin'])){

				$new_data['cubicCapacityMin']=sanitize_text_field($data['cubicCapacityMin']);

			}

			if(!empty($data['cubicCapacityMax'])){

				$new_data['cubicCapacityMax']=sanitize_text_field($data['cubicCapacityMax']);

			}

			if(!empty($data['priceMin'])){

				$new_data['priceMin']=sanitize_text_field($data['priceMin']);

			}

			if(!empty($data['priceMax'])){

				$new_data['priceMax']=sanitize_text_field($data['priceMax']);

			}

			if(!empty($data['vatable'])){

				$new_data['vatable']=$data['vatable'];

			}

			if(!empty($data['fuel'])){

				$new_data['fuel']=implode(',',$data['fuel']);

			}

			if(!empty($data['gearbox'])){

				$new_data['gearbox']=sanitize_text_field($data['gearbox']);

			}

			if(!empty($data['damageUnrepaired'])){

				$new_data['damageUnrepaired']=$data['damageUnrepaired'];

			}

			if(!empty($data['roadworthy'])){

				$new_data['roadworthy']=$data['roadworthy'];

			}

			if(!empty($data['ambitCountry'])){

				$new_data['ambitCountry']=sanitize_text_field($data['ambitCountry']);

			}

			// if($data['ambitCountry']=='DE' && !empty($data['ambitZipcode'])){

			//	$new_data['ambitZipcode']=sanitize_text_field($data['ambitZipcode']);

			//}



			// $new_data['enableNew']=sanitize_text_field(trim($data['enableNew']));



			if(!empty($data['enableNewDays'])){

				$new_data['enableNewDays']=sanitize_text_field(trim($data['enableNewDays']));

			}



			return $new_data;

		}



	//Print the Section text

	public function print_section_info()

	{

		if (isset($GLOBALS["mob_wordpressAdKeysCount"])){

		echo $GLOBALS["mob_wordpressAdKeysCount"]; // z.B.

	} else {

		echo "";

	}

	}



	



		public function mob_username_callback()

		{

			printf(

				'<input type="text" id="mob_username0" name="MobileDE_option[mob_username][0]" value="%s" />',

				isset( $this->options['mob_username'][0] ) ? esc_attr( $this->options['mob_username'][0]) : ''

			);

			?>

			<input class="button-primary" type="button" id="addAccount"

				value="+ weiterer Account" />

			<?php

		}



		public function mob_password_callback()

		{

			printf(

				'<input type="password" class="mob_password" id="mob_password0" name="MobileDE_option[mob_password][0]" value="%s" />',

				isset( $this->options['mob_password'][0] ) ? esc_attr( $this->options['mob_password'][0]) : ''

			);

			if (isset($this->options['mob_username'])){

			for($i = 1; $i < count($this->options['mob_username']); $i ++) {

				echo '<tr valign="top"><th colspan="2" scope="row"><hr /></th>';

				

				echo '<tr valign="top"><th scope="row">Benutzername</th><td>';

				printf('<input type="text" id="mob_username' . $i . '" name="MobileDE_option[mob_username][' . $i .

						 ']" value="%s" />', 

								isset($this->options['mob_username'][$i]) ? esc_attr($this->options['mob_username'][$i]) : '');

				echo '</td></tr>';

				echo '<tr valign="top"><th scope="row">Passwort</th><td>';

				

				printf(

						'<input type="password" id="mob_password' . $i . '" name="MobileDE_option[mob_password][' . $i .

								 ']" value="%s" />', 

								isset($this->options['mob_password'][$i]) ? esc_attr($this->options['mob_password'][$i]) : '');

				echo '</td></tr>';

			}

		}

		echo '<tr valign="top"><th colspan="2" scope="row"><hr /></th>';

		}



		public function mob_language_callback()

		{

			echo '<select class="settingsSelect" name="MobileDE_option[mob_language]">'.

				mob_htmlToOptions($this->mob_data['languages'], false,

				isset( $this->options['mob_language'] ) ? esc_attr( $this->options['mob_language']) : ''.

				'</select>'

			);

		}

		

		public function mob_download_interval_callback()

		{

			echo '<select class="settingsSelect" name="MobileDE_option[mob_download_interval]">'.

				mob_htmlToOptions($this->mob_data['download_interval'], false,

				isset( $this->options['mob_download_interval'] ) ? esc_attr( $this->options['mob_download_interval']) : ''.

				'</select>'

			);



		}





		public function mob_image_callback()

		{

			echo '

			<sub>Bilder auf mobile.de belassen oder importieren und thumbnails Generieren?.</sub><br><br>

			<select class="settingsSelect" name="MobileDE_option[mob_image_option]">'.

				mob_htmlToOptions($this->mob_data['mob_images'], false,

				isset( $this->options['mob_image_option'] ) ? esc_attr( $this->options['mob_image_option']) : ''.

				'</select>'

			);

			log_me($this->options);

			// log_me($this->mob_data);



		}



		public function mob_bootstrap_callback()

		{

			echo '

			<sub>Twitter Bootstrap per CDN (Content Delivery Network) einbinden?</sub><br><br>

			<select class="settingsSelect" name="MobileDE_option[mob_bootstrap_option]">'.

				mob_htmlToOptions($this->mob_data['mob_bootstrap'], false,

				isset( $this->options['mob_bootstrap_option'] ) ? esc_attr( $this->options['mob_bootstrap_option']) : ''.

				'</select>'

			);

			log_me($this->options);



		}



		public function mob_slider_callback()

		{

			echo '

			<sub><a href="http://kenwheeler.github.io/slick/" target=_blank">Slickslider</a> für die Fahrzeugbilder laden?</sub><br><br>

			<select class="settingsSelect" name="MobileDE_option[mob_slider_option]">'.

				mob_htmlToOptions($this->mob_data['mob_slider'], false,

				isset( $this->options['mob_slider_option'] ) ? esc_attr( $this->options['mob_slider_option']) : ''.

				'</select>'

			);

			log_me($this->options);



		}

		public function mob_cat_tax_callback()

		{

			echo '

			<sub>Sollen die Standard-Kategorien mit Fahrzeugdaten befüllt werden?<br><br>

			<select class="settingsSelect" name="MobileDE_option[mob_cat_tax_option]">'.

				mob_htmlToOptions($this->mob_data['use_cat_tax'], false,

				isset( $this->options['mob_cat_tax_option'] ) ? esc_attr( $this->options['mob_cat_tax_option']) : ''.

				'</select>'

			);

			log_me($this->options);



		}







}



$mob_page = new mob_setting($mob_data);